/**
* \file: GstreamerVideoSink.h
*
* \version: 1.0
*
* \release: $Name:$
*
* Video sink endpoint implementation using Gstreamer
*
* \component: Baidu CarLife
*
* \author: P. Govindaraju / RBEB/GM / Pradeepa.Govindaraju@in.bosch.com
*
* \copyright (c) 2017 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
************************************************************************/

#ifndef BDCL_GSTREAMERVIDEOSINK_H_
#define BDCL_GSTREAMERVIDEOSINK_H_
#include <memory>
#include <string>
#include <bdcl/BaiduCoreCallbackDealer.h>
#include <bdcl/AditVideoSink.h>

namespace adit { namespace bdcl {
class GstreamerVideoSinkImpl;

/** @class  GstreamerVideoSink
 *  @brief  Gstreamer specific video sink implementation.
 */
class GstreamerVideoSink : public AditVideoSink
{
public:
    GstreamerVideoSink(IAditVideoSinkCallbacks* inCallbacks, CoreCallbackDealer* inCallbackDealer);
    virtual ~GstreamerVideoSink();

    void setConfigItem(std::string inKey, std::string inValue);

    bool initialize();
    void teardown();

    void configureStream();
    bool playbackStart();
    void playbackPause();

private:
    std::unique_ptr<GstreamerVideoSinkImpl> impl;
};

} } /* namespace adit { namespace bdcl { */


#endif /* BDCL_GSTREAMERVIDEOSINK_H_ */
